`timescale 100ps / 10ps

/*
 * Options for modeling byte transmission (uncomment at most 1)
 * - SUHDCHK_ZHD
 *   - Line is released (data=HiZ) after hold time
 * - SUHDCK_CKFE
 *   - Data is set during falling edge of CLK, line released at falling edge
 *     of CLK
 * - default (no option uncommented)
 *   - Data is set to 0 after hold time, line released (tCL-tSU) after
 *     last falling edge of CLK
 *
 */
//`define SUHDCHK_ZHD
`define SUHDCHK_CKFE

module stimulus 
	(
    IO,
    CLK1,
    CLK2,
		CS1n,
		CS2n,
    HBP,
    HTBSEL
	);

  inout [7:0] IO;
	
	output CS1n, CS2n;
	output CLK1, CLK2;
  output reg [2:0] HBP = 3'b000;
  output reg HTBSEL = 0;
        
	reg CSn = 1;
	reg CLK = 0;
        
	reg SI_IO0_reg=0;
  reg SO_IO1_reg=0;
  reg WPn_IO2_reg=0;
  reg IO3_reg=0;

  reg [3:0] tx;
  reg sel_dev;

  parameter SPI = 3'h1;
  parameter DPI = 3'h2;
  parameter QPI = 3'h4;

  wire SI_IO0;
  wire SO_IO1;
  wire WPn_IO2;
  wire IO3;

  /* Register Addresses */
  localparam ADDR_SR  = 32'h0;
  localparam ADDR_ISR = 32'h1;
  localparam ADDR_CR1 = 32'h2;
  localparam ADDR_CR2 = 32'h3;
  localparam ADDR_INTCR = 32'h4;
  localparam ADDR_ECCDIR = 32'h5;
  localparam ADDR_ECCEIR = 32'h6;
  localparam ADDR_ECCDOR = 32'h7;
  localparam ADDR_ECCECR = 32'h8;
  localparam ADDR_ID  = 32'h30;
  localparam ADDR_UID = 32'h40;
  localparam ADDR_SN  = 32'h50;

  `include "task.v"
  
  assign IO[0] = (tx[0] && sel_dev==1'b0) ? SI_IO0_reg : 1'bz;  
  assign IO[1] = (tx[1] && sel_dev==1'b0) ? SO_IO1_reg : 1'bz;  
  assign IO[2] = (tx[2] && sel_dev==1'b0) ? WPn_IO2_reg : 1'bz;  
  assign IO[3] = (tx[3] && sel_dev==1'b0) ? IO3_reg : 1'bz;  
  assign IO[4] = (tx[0] && sel_dev==1'b1) ? SI_IO0_reg : 1'bz;  
  assign IO[5] = (tx[1] && sel_dev==1'b1) ? SO_IO1_reg : 1'bz;  
  assign IO[6] = (tx[2] && sel_dev==1'b1) ? WPn_IO2_reg : 1'bz;  
  assign IO[7] = (tx[3] && sel_dev==1'b1) ? IO3_reg : 1'bz;  
  assign CLK1 = (sel_dev==1'b0) ? CLK : 0;
  assign CLK2 = (sel_dev==1'b1) ? CLK : 0;
  assign CS1n = (sel_dev==1'b0) ? CSn : 1'b1;
  assign CS2n = (sel_dev==1'b1) ? CSn : 1'b1;

  assign SI_IO0  = (sel_dev == 1'b0) ? IO[0] : IO[4];
  assign SO_IO1  = (sel_dev == 1'b0) ? IO[1] : IO[5];
  assign WPn_IO2 = (sel_dev == 1'b0) ? IO[2] : IO[6];
  assign IO3     = (sel_dev == 1'b0) ? IO[3] : IO[7];

  /* Expected errors : 1 */
  initial begin
    tx = 4'd0;
    sel_dev = 0;
    #10000;

//    $display("==== [TEST] Both devices: SPI WREN, WRDI ====");
//    sel_dev = 1'b0;
//    WriteEnable(SPI);
//    sel_dev = 1'b1;
//    WriteEnable(SPI);
//    sel_dev = 1'b0;
//    WriteDisable(SPI);
//    sel_dev = 1'b1;
//    WriteDisable(SPI);

    $display("==== [TEST] Both devices: QPIE, SPIE ====");
    sel_dev = 1'b0;
    QPIEnable(SPI);
    sel_dev = 1'b1;
    QPIEnable(SPI);
    sel_dev = 1'b0;
    SPIEnable(QPI);
    sel_dev = 1'b1;
    SPIEnable(QPI);

    $display("==== [TEST] WRSR, RDSR ====");
    sel_dev = 1'b0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'hCD);
    ReadStatus(SPI, 8'hCD);
    WriteStatus(SPI, 8'h35);
    ReadStatus(SPI, 8'h35); //error: no WREN
    
    $display("==== [TEST] RDAR (no checks, read only) ====");
    sel_dev = 1'b0;
    WriteEnable(SPI);
    WriteStatus(SPI,8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 32'h8);
    ReadReg(SPI, ADDR_CR2, 8'h8, 8'h8);
    ReadReg(SPI, ADDR_ID, 8'h0, 8'h8);
    ReadReg(SPI, ADDR_UID, 8'h0, 8'h8);
    ReadReg(SPI, ADDR_SN, 8'h0, 8'h8);

    $display("==== [TEST] WRAR/RDAR (with checks) ====");
    sel_dev = 1'b0;
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0); // Set latency to 0
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_SR, 8'hAA);
    ReadReg(SPI, ADDR_SR, 8'hAA, 8'h0); // 0 latency read
    WriteReg(SPI, ADDR_SR, 8'h55);
    ReadReg(SPI, ADDR_SR, 8'h55, 8'h0); //error: no WREN 
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_SR, 8'h0);
    ReadReg(SPI, ADDR_SR, 8'h0, 8'h0); // 0 latency read
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'hf); // Set latency to 15
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'hbe);
    ReadReg(SPI, ADDR_CR1, 8'hbe, 8'hf);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_INTCR, 8'h72);
    ReadReg(SPI, ADDR_INTCR, 8'h72, 8'hf);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_ISR, 8'h45);
    ReadReg(SPI, ADDR_ISR, 8'h45, 8'hf);

    $display("==== [TEST] WRAR/RDAR ECC regs (no checks) ====");
    sel_dev = 1'b0;
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'hf); // Set latency to 15
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_ECCDIR, 8'hb0);
    ReadReg(SPI, ADDR_ECCDIR, 8'hb0, 8'hf);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_ECCEIR, 8'h9c);
    ReadReg(SPI, ADDR_ECCEIR, 8'h9c, 8'hf);
    //WriteEnable(SPI);
    //WriteReg(SPI, ADDR_ECCDOR, 8'hd7);
    ReadReg(SPI, ADDR_ECCDOR, 8'hd7, 8'hf);
    //WriteEnable(SPI);
    //WriteReg(SPI, ADDR_ECCECR, 8'hb6);
    ReadReg(SPI, ADDR_ECCECR, 8'hb6, 8'hf);
    
    $display("==== [TEST] RDID ====");
    sel_dev = 1'b0;
    ReadID();

    $finish;

  end
endmodule
